<?php
/* --------------------------------------------------------------
 AdminHttpServiceProvider.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Application\Http;

use Gambio\Core\Application\ValueObjects\Path;
use Gambio\Core\Application\ValueObjects\Url;
use Gambio\Core\Application\ValueObjects\UserPreferences;
use Gambio\Admin\Layout\Smarty\LayoutLoader;
use Gambio\Admin\Layout\Smarty\TemplateTranslations;
use Gambio\Core\Application\ServiceProviders\Abstraction\AbstractBootableServiceProvider;
use Gambio\Core\Language\TextManager;
use Smarty;

/**
 * Class AdminHttpServiceProvider
 * @package Gambio\Admin\Application\Http
 */
class AdminHttpServiceProvider extends AbstractBootableServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            Smarty::class,
            ContentNavigation::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->share(Smarty::class);
        $this->application->share(ContentNavigation::class);
    }
    
    
    /**
     * @inheritDoc
     */
    public function boot(): void
    {
        $this->bootControllerInflector();
        $this->bootActionInflector();
    }
    
    
    /**
     * Boots the inflector of AdminController.
     *
     * All dependencies are injected on all children of AdminController.
     */
    private function bootControllerInflector(): void
    {
        $dependencies = [
            LayoutLoader::class,
            Smarty::class,
            TextManager::class,
            ContentNavigation::class,
            UserPreferences::class,
            TemplateTranslations::class
        ];
        $this->application->inflector(AdminController::class)->invokeMethod('initialize', $dependencies);
    }
    
    
    /**
     * Boots the inflector of AbstractAction.
     *
     * All dependencies are injected on all children of AbstractAction.
     */
    private function bootActionInflector(): void
    {
        $dependencies = [
            Url::class,
            Path::class
        ];
        
        $this->application->inflector(AbstractAction::class)->invokeMethod('initialize', $dependencies);
    }
}